import { ReactNode, ForwardRefExoticComponent } from 'react';
import type DTType from 'datatables.net';
import type { Api as DTApiType, Config as DTConfig } from 'datatables.net';
export type DataTableSlot = ((data: any, row: any) => React.JSX.Element) | ((data: any, type: string, row: any) => any) | ((data: any, type: string, row: any, meta: object) => any);
export type DataTableSlots = {
    [key: string | number]: DataTableSlot;
};
export interface DataTableProps {
    /** DataTables Ajax configuration */
    ajax?: DTConfig['ajax'];
    /** Table header */
    children?: ReactNode | undefined;
    /** Class to assign to the `<table>` */
    className?: string;
    /** DataTables column configuration */
    columns?: DTConfig['columns'];
    /** Data to populate the DataTable */
    data?: any[];
    /** ID to assign to the `<table>` */
    id?: string;
    /**
     * DataTables configuration object.
     *
     * The properties `ajax`, `columns` and `data` will be merged into this
     * object. They can be provided using their individual properties, or
     * via this object. The individual properties take priority.
     */
    options?: DTConfig;
    /**
     * Rendering slot function to use in a column. The key denotes where the
     * slot will be rendered - as an integer that is the column index, while
     * as a string it is the column's name (from `columns.name`). Each slot
     * is a function that takes two parameters and returns the element to
     * render.
     */
    slots?: DataTableSlots;
    /**
     * Event listeners. Please refer to the DT docs for details on the event
     * listeners available. The names are camelCase here.
     */
    [key: `on${string}`]: Function;
}
export interface DataTableRef {
    /**
     * Get the DataTables API instance from the component. Can be `null` if not
     * yet rendered.
     *
     * @returns DataTables API instance
     */
    dt: () => DTApiType | null;
}
/**
 * DataTables.net component for React.
 *
 * Typically a child will be given to the component to define the table header,
 * although this is option if you use the `columns.title` option of DataTables
 * to define the columns and their titles.
 *
 * See https://datatables.net/manual/react for details on how to use this
 * component.
 */
export interface DataTableComponent extends ForwardRefExoticComponent<DataTableProps & React.RefAttributes<DataTableRef>> {
    /**
     * Set the DataTables library to use for this component (e.g. the result from
     * `import DT from 'datatables.net-dt'` or `import DT from 'datatables.net-bs5'`).
     *
     * @param dtLib DataTables core library
     * @returns
     */
    use: (dtLib: DTType<any>) => void;
}
declare const Exporter: DataTableComponent;
export default Exporter;
